/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectUtils {
    public static <T, E> E getFieldValue(T t, Class<T> clazz, String filedName) {
        if (t == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(filedName);
            boolean isAccessable = field.isAccessible();
            field.setAccessible(true);
            field.setAccessible(isAccessable);
            return (E)field.get(t);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T, E> E getMethodValue(T t, Class<T> clazz, String methodName) {
        if (t == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object mValue = method.invoke(t, new Object[0]);
            return (E)mValue;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <S, D> D mappingFieldByField(S s, D d) {
        if (s == null || d == null) {
            return d;
        }
        Field[] sfields = s.getClass().getDeclaredFields();
        Field[] dfields = d.getClass().getDeclaredFields();
        try {
            Field[] fieldArray = sfields;
            int n = sfields.length;
            int n2 = 0;
            while (n2 < n) {
                Field sfield = fieldArray[n2];
                String sName = sfield.getName();
                Class<?> sType = sfield.getType();
                sfield.setAccessible(true);
                boolean sisAccessable = sfield.isAccessible();
                Field[] fieldArray2 = dfields;
                int n3 = dfields.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field dfield = fieldArray2[n4];
                    String dName = dfield.getName();
                    Class<?> dType = dfield.getType();
                    if (sName.equals(dName) && sType.toString().equals(dType.toString())) {
                        boolean disAccessable = dfield.isAccessible();
                        dfield.setAccessible(true);
                        dfield.set(d, sfield.get(s));
                        dfield.setAccessible(disAccessable);
                        break;
                    }
                    ++n4;
                }
                sfield.setAccessible(sisAccessable);
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return d;
    }

    public static <S, D> D mappingFieldByMethod(S s, D d) {
        if (s == null || d == null) {
            return d;
        }
        Field[] sfields = s.getClass().getDeclaredFields();
        Field[] dfields = d.getClass().getDeclaredFields();
        Class<?> scls = s.getClass();
        Class<?> dcls = d.getClass();
        try {
            Field[] fieldArray = sfields;
            int n = sfields.length;
            int n2 = 0;
            while (n2 < n) {
                Field sfield = fieldArray[n2];
                String sName = sfield.getName();
                Class<?> sType = sfield.getType();
                String sfieldName = String.valueOf(sName.substring(0, 1).toUpperCase()) + sName.substring(1);
                Method sGetMethod = scls.getMethod("get" + sfieldName, new Class[0]);
                Object value = sGetMethod.invoke(s, new Object[0]);
                Field[] fieldArray2 = dfields;
                int n3 = dfields.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field dfield = fieldArray2[n4];
                    String dName = dfield.getName();
                    Class<?> dType = dfield.getType();
                    if (dName.equals(sName) && sType.toString().equals(dType.toString())) {
                        Method dSetMethod = dcls.getMethod("set" + sfieldName, sType);
                        dSetMethod.invoke(d, value);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return d;
    }

    public static <S, D> D mappingFieldByMethodExcludeParamNames(S s, D d, String ... excludeParamNames) {
        if (s == null || d == null) {
            return d;
        }
        Field[] sfields = s.getClass().getDeclaredFields();
        Field[] dfields = d.getClass().getDeclaredFields();
        Class<?> scls = s.getClass();
        Class<?> dcls = d.getClass();
        try {
            Field[] fieldArray = sfields;
            int n = sfields.length;
            int n2 = 0;
            while (n2 < n) {
                Field sfield = fieldArray[n2];
                String sName = sfield.getName();
                Class<?> sType = sfield.getType();
                String sfieldName = String.valueOf(sName.substring(0, 1).toUpperCase()) + sName.substring(1);
                Method sGetMethod = scls.getMethod("get" + sfieldName, new Class[0]);
                Object value = sGetMethod.invoke(s, new Object[0]);
                Field[] fieldArray2 = dfields;
                int n3 = dfields.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field dfield = fieldArray2[n4];
                    String dName = dfield.getName();
                    Class<?> dType = dfield.getType();
                    if (dName.equals(sName) && sType.toString().equals(dType.toString()) && excludeParamNames != null) {
                        String[] stringArray = excludeParamNames;
                        int n5 = excludeParamNames.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String excludeParamName = stringArray[n6];
                            if (!sName.equals(excludeParamName)) {
                                Method dSetMethod = dcls.getMethod("set" + sfieldName, sType);
                                dSetMethod.invoke(d, value);
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return d;
    }

    public static <S, D> D mappingFieldByMethodIncludeParamNames(S s, D d, String ... includeParamNames) {
        if (s == null || d == null) {
            return d;
        }
        Field[] sfields = s.getClass().getDeclaredFields();
        Field[] dfields = d.getClass().getDeclaredFields();
        Class<?> scls = s.getClass();
        Class<?> dcls = d.getClass();
        try {
            Field[] fieldArray = sfields;
            int n = sfields.length;
            int n2 = 0;
            while (n2 < n) {
                Field sfield = fieldArray[n2];
                String sName = sfield.getName();
                Class<?> sType = sfield.getType();
                String sfieldName = String.valueOf(sName.substring(0, 1).toUpperCase()) + sName.substring(1);
                Method sGetMethod = scls.getMethod("get" + sfieldName, new Class[0]);
                Object value = sGetMethod.invoke(s, new Object[0]);
                if (includeParamNames != null) {
                    String[] stringArray = includeParamNames;
                    int n3 = includeParamNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String excludeParam = stringArray[n4];
                        if (sName.equals(excludeParam)) {
                            Field[] fieldArray2 = dfields;
                            int n5 = dfields.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Field dfield = fieldArray2[n6];
                                String dName = dfield.getName();
                                Class<?> dType = dfield.getType();
                                if (dName.equals(sName) && sType.toString().equals(dType.toString())) {
                                    Method dSetMethod = dcls.getMethod("set" + sfieldName, sType);
                                    dSetMethod.invoke(d, value);
                                    break;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return d;
    }
}

